unit main;

interface

uses
  Windows, Sysutils, Forms, Controls, Classes, StdCtrls,
  DirectXGraphics,
  d3dx8;

type
  TVERTEX = record
    position    : TD3DXVector3;									// Vertexposition
    texkor      : TD3DXVector2;									// Texturkoordinaten
  end;

  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cmbMag: TComboBox;
    cmbMin: TComboBox;
    cmbMip: TComboBox;
    cmbanzahl: TComboBox;
    Button1: TButton;
    Label4: TLabel;
    edtlodbias: TEdit;
    Label5: TLabel;
    edtlevel: TEdit;
    Label6: TLabel;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cmbMagChange(Sender: TObject);
    procedure cmbMinChange(Sender: TObject);
    procedure cmbMipChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    procedure OnIdle(Sender: TObject; var done: boolean);
  public
    { Public declarations }
  end;

const                   // Format von THVERTEX
  D3DFVF_TVERTEX = ( D3DFVF_XYZ or D3DFVF_TEX1 );

var
  Form1: TForm1;
  vb: IDirect3DVertexBuffer8;
  textur: IDirect3DTexture8;
  d3d8 : IDirect3D8;
  d3ddev8 : IDirect3DDevice8;
implementation

{$R *.DFM}

procedure SetupViewandProjection;
var
  matView, matProj: TD3DXMatrix;
  _v1, _v2, _v3 : TD3DXVector3;
begin
  // View.
  _v1 := D3DXVector3( 0, 0, -4 );
  _v2 := D3DXVector3( 0.0, 0.0,  0.0);
  _v3 := D3DXVector3( 0.0, 1.0,  0.0);
  D3DXMatrixLookAtLH(matView, _v1, _v2, _v3);
  D3DDEV8.SetTransform(D3DTS_VIEW, matView);

  // Projection.
  D3DXMatrixPerspectiveFovLH(matProj, D3DX_PI / 4, 1.0, 0.1, 100.0);
  D3DDEV8.SetTransform(D3DTS_PROJECTION, matProj);
end;

procedure SetupMatrizes;
var
  matworld, matrot : TD3DXMatrix;
begin
  D3DXMatrixRotationY( matRot, gettickcount * 0.0004 );
  D3DXMatrixTranslation( matWorld, 0, 0, sin(gettickcount * 0.001)*5+1.2 );
  D3DXMatrixMultiply( matworld, matRot, matworld );
  d3ddev8.SetTransform( D3DTS_WORLD, matWorld );
end;

procedure TForm1.OnIdle(Sender: TObject; var done: boolean);
begin
  done := false;
  d3dDev8.Clear( 0, nil, D3DCLEAR_TARGET, D3DCOLOR_XRGB( 50, 50, 50 ), 1.0, 0 );
  d3dDev8.BeginScene;
  SetupViewandProjection;
  SetupMatrizes;
  d3ddev8.SetTexture( 0, textur );
  d3dDev8.SetStreamSource( 0, vb, sizeof( TVERTEX ) );
  d3dDev8.SetVertexShader( D3DFVF_TVERTEX );
  d3ddev8.DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );
  d3ddev8.EndScene;
  d3ddev8.Present( nil, nil, 0, nil );
end;

function GetViewPort( _minz, _maxz: Single; _width, _height, _x, _y: LongWord): TD3DViewPort8;
begin
  with result do
  begin
    minz   := _minz;
    maxz   := _maxz;
    width  := _width;
    height := _height;
    x      := _x;
    y      := _y;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  d3ddm  : TD3DDISPLAYMODE;
  d3dpp  : TD3DPRESENT_PARAMETERS;
  vertices : Array[0..3] of TVertex;
  pvertices : PByte;
  d3dvp : td3dviewport8;
  lodb, maxl : LongWord;
begin

// Erstellen von Direct3D8
  d3d8 := Direct3DCreate8( D3D_SDK_VERSION );
  if ( d3d8 = nil ) then
    Application.Terminate;

// Auslesen der aktuellen Bildschirmeinstellungen (Auflsung, Format, Refreshrate)
  if ( d3d8.GetAdapterDisplayMode( D3DADAPTER_DEFAULT, d3ddm ) <> D3D_OK ) then
    Application.Terminate;

// Alle Werte des Records d3dpp werden auf 0 bzw Nil gestellt
  ZeroMemory( @d3dpp, sizeof( d3dpp ) );

// Das zuknftige Device wird ber das Record eingestellt
  d3dpp.Windowed := TRUE;
  d3dpp.SwapEffect := D3DSWAPEFFECT_DISCARD;
  d3dpp.BackBufferFormat := d3ddm.Format;
  d3dpp.EnableAutoDepthStencil := FALSE;

// Das Device wird erstellt
  if ( d3d8.CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, handle,
       D3DCREATE_SOFTWARE_VERTEXPROCESSING,
       d3dpp, d3ddev8 ) <> D3D_OK ) then
    Application.Terminate;

  d3ddev8.Clear( 0, nil, D3DCLEAR_TARGET, D3DCOLOR_XRGB( 192, 192, 192 ), 1.0, 1 );

  vertices[0].position := D3DXVector3( -1, 1, 0 );
  vertices[0].texkor := D3DXVector2( 0, 0 );
  vertices[1].position := D3DXVector3( 1, 1, 0 );
  vertices[1].texkor := D3DXVector2( 1, 0 );
  vertices[2].position := D3DXVector3( -1, -1, 0 );
  vertices[2].texkor := D3DXVector2( 0, 1 );
  vertices[3].position := D3DXVector3( 1, -1, 0 );
  vertices[3].texkor := D3DXVector2( 1, 1 );

  d3ddev8.CreateVertexBuffer( 4*sizeof( tvertex ),
  													  0,
                              D3DFVF_TVERTEX,
                              D3DPOOL_DEFAULT,
                              vb );

//  setlength( vertices, 4 );
  vb.Lock( 0, sizeof(vertices), pvertices, 0 );
  move( vertices, pvertices^, sizeof(vertices) );
  vb.Unlock;

  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( FALSE ) );
  d3ddev8.SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

  D3DXCreateTextureFromFileEx( d3ddev8,
  														 'linien.bmp',
                               0, 0, 1, 0,
                               D3DFMT_A1R5G5B5,
                               D3DPOOL_DEFAULT,
                               D3DX_FILTER_LINEAR,
                               D3DX_FILTER_LINEAR,
                               0,
                               nil,
                               nil,
                               textur );

  d3ddev8.Clear( 0, nil, D3DCLEAR_TARGET, D3DCOLOR_XRGB( 190, 190, 190 ), 1.0, 1 );
  d3dvp := GetViewPort( 0.0, 1.0, 300, 300, 10, 10);
  d3ddev8.SetViewport( d3dvp );

  d3ddev8.SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_POINT );
  d3ddev8.SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_POINT );
  d3dDev8.SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR );
  d3ddev8.GetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, lodb );
  d3ddev8.GetTextureStageState(0, D3DTSS_MAXMIPLEVEL, maxl );
  cmbmag.ItemIndex:= 0;
  cmbmin.ItemIndex:= 0;
  cmbmip.ItemIndex:= 0;
  cmbanzahl.ItemIndex:= 0;
  edtlodbias.Text := inttostr( lodb );
  edtlevel.Text := inttostr( maxl );
  Application.OnIdle := OnIdle;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if textur<>nil then textur := nil;
  if vb<>nil then vb := nil;
  if d3ddev8<>nil then d3ddev8 := nil;
  if d3d8<>nil then d3d8 := nil;
end;

function GetTexFFlag( _name : string ): Integer;
begin
  result:= D3DTEXF_NONE;

  if (_name = 'D3DTEXF_POINT') then begin
    result:= D3DTEXF_POINT;
  end;
  if (_name = 'D3DTEXF_LINEAR') then begin
    result:= D3DTEXF_LINEAR;
  end;
  if (_name = 'D3DTEXF_ANISOTROPIC') then begin
    result:= D3DTEXF_ANISOTROPIC;
  end;
  if (_name = 'D3DTEXF_FLATCUBIC') then begin
    result:= D3DTEXF_FLATCUBIC;
  end;
  if (_name = 'D3DTEXF_GAUSSIANCUBIC') then begin
    result:= D3DTEXF_GAUSSIANCUBIC;
  end;
end;

procedure TForm1.cmbMagChange(Sender: TObject);
begin
  d3ddev8.SetTextureStageState( 0,
                                D3DTSS_MAGFILTER,
  															GetTexFFlag( cmbMag.Text ));
end;

procedure TForm1.cmbMinChange(Sender: TObject);
begin
  d3ddev8.SetTextureStageState( 0,
                                D3DTSS_MINFILTER,
  															GetTexFFlag( cmbMin.Text ));
end;

procedure TForm1.cmbMipChange(Sender: TObject);
begin
  d3ddev8.SetTextureStageState( 0,
                                D3DTSS_MIPFILTER,
  															GetTexFFlag( cmbMip.Text ));
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 if (textur<>nil) then begin
   textur := nil;
 end;
  D3DXCreateTextureFromFileEx( d3ddev8,
  														 'linien.bmp',
                               0, 0, strtoint(cmbanzahl.text), 0,
                               D3DFMT_A1R5G5B5,
                               D3DPOOL_DEFAULT,
                               D3DX_FILTER_LINEAR,
                               D3DX_FILTER_LINEAR,
                               0,
                               nil,
                               nil,
                               textur );
end;

function F2DW(f: Single): DWORD;
begin
  Result:= PDWord(@f)^;
end;
 
procedure TForm1.Button2Click(Sender: TObject);
begin
  d3ddev8.SetTextureStageState(
    0,
    D3DTSS_MIPMAPLODBIAS,
    f2dw(
      strtofloat(
        edtlodbias.text
        )
      )
    );
  d3ddev8.SetTextureStageState(0, D3DTSS_MAXMIPLEVEL, strtoint(edtlevel.text) );
end;

end.
