unit main;

interface

uses
  Windows,
  SysUtils,
  Classes,
  Controls,
  Forms,
  DirectXGraphics,
  d3dx8;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure OnIdle(Sender: TObject; var done: boolean);
    { Private declarations }
  public
    { Public declarations }
  end;


type
  CUSTOMVERTEX = record
    x, y, z : Single;   // Positionskoordinaten
    color : TD3DColor;  // Farbe 
  end;

const                   // Format von CUSTOMVERTEX
  D3DFVF_CUSTOMVERTEX = ( D3DFVF_XYZ or D3DFVF_DIFFUSE );
 
var
  Form1: TForm1;
  d3d8: IDirect3D8;
  d3ddev8: IDirect3DDevice8;
  vbuffer: IDirect3DVertexBuffer8;

implementation

{$R *.DFM}

function GetCustomVertex(_x, _y, _z: single; _color: TD3DColor): CUSTOMVERTEX;
begin
  with Result do
   begin
     x := _x;
     y := _y;
     z := _z;
     color := _color;
   end;
end;

function InitGeometry: HRESULT;
var
  Vertices: Array[0..99] of CUSTOMVERTEX;
  cx: Integer;
  theta: Single;
  pVertices : PByte;
begin
  // Wenn die Funktion vorzeitig abgebrochen wird, wird E_FAIL zurckgegeben
  Result := E_FAIL;

  // In das Vertex-Array werden die Koordinaten und Farben geschrieben
  // Initialize the vertices.
  for cx := 0 to 49 do
  begin
    theta := ( 2 * D3DX_PI * cx ) / 49;
    Vertices[ 2 * cx ] := GetCustomVertex(sin( theta ), -1.0, cos( theta ), $FF00FF00); // Rot
    Vertices[ 2 * cx + 1 ] := GetCustomVertex(sin( theta ),  1.0, cos( theta ), $FFFF0000); // Grn
  end;

  // Erstellen des Vertexbuffers
  if ( d3ddev8.CreateVertexBuffer( sizeof( CUSTOMVERTEX ) * 100, 0, D3DFVF_CUSTOMVERTEX,
    D3DPOOL_DEFAULT, vbuffer ) <> D3D_OK ) then Exit;


  if ( vbuffer.Lock( 0, sizeof( Vertices ), pVertices, 0 ) <> D3D_OK ) then Exit;
  Move( Vertices, pVertices^, sizeof( Vertices ) );
  vbuffer.Unlock;

  result:= D3D_OK;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  d3ddm : TD3DDISPLAYMODE;
  d3dpp : TD3DPRESENT_PARAMETERS;
begin
// Erstellen von Direct3D8
  d3d8 := Direct3DCreate8( D3D_SDK_VERSION );
  if ( d3d8 = nil ) then
    Application.Terminate;

// Auslesen der aktuellen Bildschirmeinstellungen (Auflsung, Format, Refreshrate)
  if ( d3d8.GetAdapterDisplayMode( D3DADAPTER_DEFAULT, d3ddm ) <> D3D_OK ) then
    Application.Terminate;

// Alle Werte des Records d3dpp werden auf 0 bzw Nil gestellt
  ZeroMemory( @d3dpp, sizeof( d3dpp ) );

// Das zuknftige Device wird ber das Record eingestellt
  d3dpp.Windowed := TRUE;
  d3dpp.SwapEffect := D3DSWAPEFFECT_DISCARD;
  d3dpp.BackBufferFormat := d3ddm.Format;
  d3dpp.EnableAutoDepthStencil := TRUE;
  d3dpp.AutoDepthStencilFormat := D3DFMT_D16;

// Das Device wird erstellt
  if ( d3d8.CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, handle,
       D3DCREATE_SOFTWARE_VERTEXPROCESSING,
       d3dpp, d3ddev8 ) <> D3D_OK ) then
    Application.Terminate;

  InitGeometry;

  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( FALSE ) );
  d3ddev8.SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
  d3ddev8.SetRenderState( D3DRS_ZENABLE, CARDINAL( TRUE ) );

  Application.OnIdle:= OnIdle;
end;

procedure SetupViewandProjection;
var
  matView, matProj: TD3DXMatrix;
  _v1, _v2, _v3 : TD3DXVector3;
begin
  // View.
  _v1 := D3DXVector3( cos(gettickcount/3000)*7, 0, sin(gettickcount/3000)*3);
  _v2 := D3DXVector3( 0.0, 0.0,  0.0);
  _v3 := D3DXVector3( 0.0, 1.0,  0.0);
  D3DXMatrixLookAtLH(matView, _v1, _v2, _v3);
  D3DDEV8.SetTransform(D3DTS_VIEW, matView);

  // Projection.
  D3DXMatrixPerspectiveFovLH(matProj, D3DX_PI / 4, form1.width/form1.height, 1.0, 100.0);
  D3DDEV8.SetTransform(D3DTS_PROJECTION, matProj);
end;

procedure SetupZylinder1;
var
  matWorld, matScale, matMove: TD3DXMatrix;
begin
  // Einstellungen des ersten Zylinders
  D3DXMatrixScaling( matScale, 0.6, 0.6, 0.6 );
  D3DXMatrixRotationX(matWorld, getTickCount / 1000);
  D3DXMatrixTranslation( matMove, 1, 0, 0);
  D3DXMatrixMultiply( matWorld, matScale, matWorld );
  D3DXMatrixMultiply( matWorld, matWorld, matMove );
  D3DDEV8.SetTransform(D3DTS_WORLD, matWorld);
end;

procedure SetupZylinder2;
var
  matWorld: TD3DXMatrix;
  matScale, matMove, matRot: TD3DXMatrix;
begin
  // Einstellen des zweiten Zylinders
  D3DXMatrixScaling( matScale, 0.3, 0.6, 0.6 );
  D3DXMatrixRotationX( matWorld, D3DX_PI / 2 );
  D3DXMatrixRotationY(matrot, 1 );
  D3DXMatrixTranslation( matMove, -1, 0, 0);
  D3DXMatrixMultiply( matWorld, matScale, matWorld );
  D3DXMatrixMultiply( matWorld, matWorld, matRot );
  D3DXMatrixMultiply( matWorld,  matWorld, matMove );
  D3DDEV8.SetTransform(D3DTS_WORLD, matWorld);
end;

procedure Schatten;
var
  matshadow, matWorld: TD3DXMatrix;
  plane: TD3DXPlane;
  vlicht: TD3DXVector4;
  v1, v2, v3: TD3DXVector3;
begin
  v1:= D3DXVector3( -1, -1, 0);
  v2:= D3DXVector3( 0, -1, 0);
  v3:= D3DXVector3( -1, -1, -1);
  D3DXPlaneFromPoints( plane, v1, v2, v3);
  vlicht:= D3DXVector4(-4, 6, -4, 1);
  D3DXMatrixShadow( matShadow, vlicht, plane);

  d3ddev8.GetTransform( D3DTS_WORLD, matWorld);
  D3DXMatrixMultiply( matWorld, matWorld, matShadow);
  d3ddev8.SetTransform( D3DTS_WORLD, matWorld);
end;

procedure TForm1.OnIdle(Sender: TObject; var done: boolean);
begin
  done:= false;
  // den Backbuffer lschen
  d3dDev8.Clear( 0, nil, D3DCLEAR_TARGET or D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB( 50, 50, 50 ), 1.0, 0 );
  d3dDev8.BeginScene;

  // Einstellen der StreamSource und der VertexShader
  d3dDev8.SetStreamSource( 0, vBuffer, sizeof( CUSTOMVERTEX ) );
  d3dDev8.SetVertexShader( D3DFVF_CUSTOMVERTEX );

  // Perspektive und Blickwinkel einstellen
  SetupViewandProjection;

//////////////////////////////////////////////////////
// Rendern des ersten Zylinders mit Schatten
//////////////////////////////////////////////////////
  SetupZylinder1;
  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( FALSE ) );
  d3dDev8.DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 98 );

  Schatten;
  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( TRUE ) );
  d3dDev8.DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 98 );

//////////////////////////////////////////////////////
// Rendern des zweiten Zylinders mit Schatten
//////////////////////////////////////////////////////
  SetupZylinder2;
  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( FALSE ) );
  d3dDev8.DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 98 );

  Schatten;
  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( TRUE ) );
  d3dDev8.DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 98 );

  d3ddev8.EndScene;
  d3ddev8.Present( nil, nil, 0, nil );
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if vbuffer <> nil then vbuffer := nil;
  if d3ddev8 <> nil then d3ddev8 := nil;
  if d3d8 <> NIL then d3d8:= NIL;
end;

end.
