unit main;

interface

uses
  Windows,
  Messages,
  Forms,
  DirectXGraphics,
  d3dx8;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure OnIdle(Sender: TObject; var done: boolean);
    { Private declarations }
  public
    { Public declarations }
  end;

type
  CUSTOMVERTEX = record
    x, y, z : Single;   // Positionskoordinaten
    color : TD3DColor;  // Farbe
  end;

const                   // Format von CUSTOMVERTEX
  D3DFVF_CUSTOMVERTEX = ( D3DFVF_XYZ or D3DFVF_DIFFUSE );

var
  Form1: TForm1;
  d3d8: IDirect3D8;
  d3ddev8: IDirect3DDevice8;
  vbuffer: IDirect3DVertexBuffer8;
  ibuffer: IDirect3DIndexBuffer8;

implementation

{$R *.DFM}

function GetCustomVertex(_x, _y, _z: single; _color: TD3DColor): CUSTOMVERTEX;
begin
  with Result do
   begin
     x := _x;
     y := _y;
     z := _z;
     color := _color;
   end;
end;

function InitGeometry: HRESULT;
var
  vertices: Array[0..99] of CUSTOMVERTEX;
  pvertices: PByte;
  indizes: Array[0..((81*6) - 1)] of WORD;
  z: Word;
  pindizes: PByte;
  x,y: byte;

begin
  result:= E_FAIL;

  for y:= 0 to 9 do
    for x:= 0 to 9 do
      vertices[y*10 + x]:= GetCustomVertex( x-5, -(x-5)*(x-5)*0.1 + (y-4)*(y-4)*0.07, y-5, D3DColor_RGBA(x*10, 255 - y*10, (x+y)*10, 0));

  x:= 0;
  y:= 0;
  z:= 0;

  for y:= 0 to 8 do
    for x:= 0 to 8 do
    begin
      indizes[z]:= y*10 + x;
      inc(z);
      indizes[z]:= y*10 + x + 11;
      inc(z);
      indizes[z]:= y*10 + x + 1;
      inc(z);
      indizes[z]:= y*10 + x;
      inc(z);
      indizes[z]:= (y+1)*10 + x;
      inc(z);
      indizes[z]:= y*10 + x + 11;
      inc(z);
    end;

  d3ddev8.CreateVertexBuffer( 100 * sizeof(CUSTOMVERTEX), 0, D3DFVF_CUSTOMVERTEX, D3DPool_Default, vbuffer);
  d3ddev8.CreateIndexBuffer( sizeof(indizes), 0, D3DFMT_INDEX16 , D3DPOOL_DEFAULT, ibuffer);

  vbuffer.Lock(0, sizeof(vertices), pvertices, 0);
    move( vertices, pvertices^, sizeof(vertices) );
  vbuffer.unlock;

  ibuffer.Lock( 0, sizeof(indizes), pindizes, 0);
    move( indizes, pindizes^, sizeof(indizes));
  ibuffer.UnLock;

  result:= D3D_OK;
end;

procedure SetupViewAndProjection;
var
  matView, matProj: TD3DXMatrix;
  _v1, _v2, _v3 : TD3DXVector3;
begin
  // View.
  _v1 := D3DXVector3( cos(gettickcount/2000)*10,5, sin(gettickcount/2000)*10);
  _v2 := D3DXVector3( 0.0, 0.0,  0.0);
  _v3 := D3DXVector3( 0.0, 1.0,  0.0);
  D3DXMatrixLookAtLH(matView, _v1, _v2, _v3);
  D3DDEV8.SetTransform(D3DTS_VIEW, matView);

  // Projection.
  D3DXMatrixPerspectiveFovLH(matProj, D3DX_PI / 4, form1.width/form1.height, 1.0, 100.0);
  D3DDEV8.SetTransform(D3DTS_PROJECTION, matProj);
end;

procedure TForm1.OnIdle(Sender: TObject; var done: boolean);

begin
  done:= false;
  // den Backbuffer lschen
  d3dDev8.Clear( 0, nil, D3DCLEAR_TARGET or D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB( 50, 50, 50 ), 1.0, 0 );
  d3dDev8.BeginScene;

  SetupViewAndProjection;

  d3ddev8.setstreamsource( 0, vbuffer, sizeof(CUSTOMVERTEX));
  d3ddev8.SetVertexShader(D3DFVF_CUSTOMVERTEX);
  d3ddev8.SetIndices(ibuffer, 0);
  d3ddev8.DrawIndexedPrimitive( d3dpt_trianglelist, 0, 100, 0, 486 div 3);

  d3ddev8.EndScene;
  d3ddev8.Present( nil, nil, 0, nil );
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  d3ddm : TD3DDISPLAYMODE;
  d3dpp : TD3DPRESENT_PARAMETERS;
begin
// Erstellen von Direct3D8
  d3d8 := Direct3DCreate8( D3D_SDK_VERSION );
  if ( d3d8 = nil ) then
    Application.Terminate;

// Auslesen der aktuellen Bildschirmeinstellungen (Auflsung, Format, Refreshrate)
  if ( d3d8.GetAdapterDisplayMode( D3DADAPTER_DEFAULT, d3ddm ) <> D3D_OK ) then
    Application.Terminate;

// Alle Werte des Records d3dpp werden auf 0 bzw Nil gestellt
  ZeroMemory( @d3dpp, sizeof( d3dpp ) );

// Das zuknftige Device wird ber das Record eingestellt
  d3dpp.Windowed := TRUE;
  d3dpp.SwapEffect := D3DSWAPEFFECT_DISCARD;
  d3dpp.BackBufferFormat := d3ddm.Format;
  d3dpp.EnableAutoDepthStencil := TRUE;
  d3dpp.AutoDepthStencilFormat := D3DFMT_D16;

// Das Device wird erstellt
  if ( d3d8.CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, handle,
       D3DCREATE_SOFTWARE_VERTEXPROCESSING,
       d3dpp, d3ddev8 ) <> D3D_OK ) then
    Application.Terminate;

  if InitGeometry <> D3D_OK then Application.Terminate;

  d3ddev8.SetRenderState( D3DRS_LIGHTING, Cardinal( FALSE ) );
  d3ddev8.SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
  d3ddev8.SetRenderState( D3DRS_ZENABLE, CARDINAL( TRUE ) );

  Application.OnIdle:= OnIdle;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if vbuffer <> nil then vbuffer := nil;
  if ibuffer <> nil then ibuffer := nil;
  if d3ddev8 <> nil then d3ddev8 := nil;
  if d3d8 <> NIL then d3d8:= NIL;
end;

end.
 