import java.applet.Applet;
import java.awt.*;
/*
public class CodeArea extends Object {
 int start;
 int end;
 char[] description;

 CodeArea(int a, int e, char[] d) {
  start=a; end=e; description=d
 }

 boolean match(int code) {
  return (code>=start) & (code+0xFF<=end); 
 }

 String toString() {
  return Integer.toString(start,16)+" "+Integer.toString(end,16)+" "+
    description;
 }
}
*/
public class t extends Applet {
 int start=0;
 Button prev,next;
 static final String[] area={
   "\u0020\u007E Lateinische Zeichen (US-ASCII)",
   "\u00A0\u00FF Westeuropäische lateinische Zeichen (Latin-1)",
   "\u0100\u017F Lateinisch, Erweiterung A",
   "\u0180\u024F Lateinisch, Erweiterung B",
   "\u0250\u02AF Internationales Phonetisches Alphabet (IPA)",
   "\u02B0\u02FF Alleinstehende diakritische Zeichen",
   "\u0300\u036F Kombinierende diakritische Zeichen",
   "\u0370\u03CF Einfaches Griechisch (basierend auf ISO8859-7)",
   "\u03D0\u03FF Griechische Zeichen und Koptisch",
   "\u0400\u04FF Kyrillisch (basierend auf ISO8859-5)",
   "\u0500\u042F Kyrillisch (Ergänzung)",
   "\u0530\u058F Armenisch",
   "\u0590\u05CF Hebräisch, Erweiterung A",
   "\u05D0\u05EA Einfaches Hebräisch (basierend auf ISO8859-8)",
   "\u05EB\u05FF Hebräisch, Erweiterung B",
   "\u0600\u0652 Einfaches Arabisch (basierend auf ISO8859-6)",
   "\u0653\u06FF Erweitertes Arabisch",
   "\u0700\u074F Syrisch",
   "\u0750\u077F Arabisch, Ergänzung",
   "\u0780\u07BF Thaana",
   "\u07C0\u07FF N'Ko",
   "\u0800\u083F Samaritanisch",
   "\u0840\u087F Mandäisch",
   "\u0880\u08FF Sonstige linksläufige Schriften (noch nicht belegt)",
   "\u0900\u097F Devanagari (basierend auf ISCII 1988)",
   "\u0980\u09FF Bengali (basierend auf ISCII 1988)",
   "\u0A00\u0A7F Gurmukhi (basierend auf ISCII 1988)",
   "\u0A80\u0AFF Gujarati (basierend auf ISCII 1988)",
   "\u0B00\u0B7F Oriya (basierend auf ISCII 1988)",
   "\u0B80\u0BFF Tamil (basierend auf ISCII 1988)",
   "\u0C00\u0C7F Telegu (basierend auf ISCII 1988)",
   "\u0C80\u0CFF Kannada (basierend auf ISCII 1988)",
   "\u0D00\u0D7F Malajalam (basierend auf ISCII 1988)",
   "\u0D80\u0DFF Singhalesisch (noch nicht abgeschlossen)",
   "\u0E00\u0E7F Thai (Siamesisch) (basierend auf TIS 620-2529)",
   "\u0E80\u0EFF Laotisch (basierend auf TIS 620-2529)",
   "\u0F00\u0FFF Tibetisch",
   "\u1000\u109F Birmanisch",
   "\u10A0\u10CF Georgisch erweitert",
   "\u10D0\u10FF Einfaches Georgisch",
   "\u1100\u11FF Hangul Jamo",
   "\u1200\u137F Äthiopisch",
   "\u1380\u139F Äthiopisch, Zusatz",
   "\u13A0\u13FF Chekoree",
   "\u1400\u167F Vereinheitlichte Silbenzeichen kanadischer Ureinwohner",
   "\u1680\u169F Ogam",
   "\u16A0\u16FF Runen",
   "\u1700\u171F Tagalog",
   "\u1720\u173F Hanunóo",
   "\u1740\u175F Buid",
   "\u1760\u177F Tagbanuwa",
   "\u1780\u17FF Khmer",
   "\u1800\u18AF Mongolisch",
   "\u18A0\u18FF Vereinheitlichte Silbenzeichen kanadischer Ureinwohner, erweitert",
   "\u1900\u194F Limbu",
   "\u1950\u197F Tai Le",
   "\u1980\u19DF Neu-Tai-Lue",
   "\u19E0\u19FF Khmer-Symbole",
   "\u1A00\u1A1F Buginesisch",
   "\u1A20\u1AAF Lanna",
   "\u1B00\u1B7F Balinesisch",
   "\u1B80\u1BBF Sundanesisch",
   "\u1BC0\u1BFF Batak",
   "\u1C00\u1C4F Lepcha",
   "\u1C40\u1C7F Ol Chiki",
   "\u1E00\u1EFF Latin, zusätzliche Erweiterung",
   "\u1F00\u1FFF Erweitertes Griechisch",
   "\u2000\u206F Allgemeine Satzzeichen",
   "\u2070\u209F Hoch- und tiefgestellte Zeichen",
   "\u20A0\u20CF Währungszeichen",
   "\u20D0\u20FF Kombinierende diakritische Zeichen und Symbole",
   "\u2100\u214F Buchstabenähnliche Symbole",
   "\u2150\u218F Zahlenformen",
   "\u2190\u21FF Pfeile",
   "\u2200\u22FF Mathematische Operatoren",
   "\u2300\u23FF Verschiedene technische Zeichen",
   "\u2400\u243F Steuerungszeichen",
   "\u2440\u245F Optische Zeichenerkennung",
   "\u2460\u24FF Eingeschlossene alphanumerische Zeichen",
   "\u2500\u257F Rahmenelemente",
   "\u2580\u259F Blockelemente",
   "\u25A0\u25FF Geometrische Formen",
   "\u2600\u26FF Diverse Symbole",
   "\u2700\u27BF Dingbats",
   "\u3000\u303F CJK-Symbole und -Satzzeichen",
   "\u3040\u309F Hiragana (basierend auf JIS X0208-1990)",
   "\u30A0\u30FF Katakana (basierend auf JIS X0208-1990)",
   "\u3100\u312F Bopomofo (basierend auf GB 2312-80)",
   "\u3190\u319F Diverse CJK",
   "\u3200\u32FF Eingeschlossene CJK-Buchstaben und -Monate",
   "\u3300\u33FF CJK-Kompatibilität",
   "\u3400\u3D2D Hangul (basierend auf KSC 5601-1987)",
   "\u3D2E\u44B7 Hangul, Ergänzung A",
   "\u44B8\u4DFF Hangul, Ergänzung B",
   "\u4E00\u9FFF Han-Zeichen aus China, Japan, Korea und Vietnam",
   "\uE000\uF8FF Individuell nutzbarer Bereich",
   "\uF900\uFAFF Ideographen für CJK-Kompatibilität",
   "\uFB00\uFB4F Alphabetische Präsentationsformen",
   "\uFB50\uFDFF Arabische Präsentationsformen A",
   "\uFE20\uFE2F Kombinierende Halbformen",
   "\uFE30\uFE4F CJK-Kompatibilitätsformen (Vorzeichen und Überstriche)",
   "\uFE50\uFE6F Kleine Formvarianten",
   "\uFE70\uFEFE Arabische Präsentationsformen B",
   "\uFEFF\uFEFF Leerzeichen ohne Breite und Umbruch (Byte Order Mark)",
   "\uFF00\uFFEF Halbbreite und ganzbreite Formen",
   "\uFFF0\uFFFC Spezielle Zeichen",
   "\uFFFD\uFFFD Ersetzungszeichen",
   "\uFFFE\uFFFF vom Standard ausgeschlossen",
   "\uD874\uDD00\uD874\uDDFF Notenschriftzeichen"
 };

 public void init(){
  try {
   start=Integer.parseInt(getParameter("start"),16);
  }catch (NumberFormatException e){}
  prev=new Button("<<");
  add(prev);
  next=new Button(">>");
  add(next);
 }

 public String toHexCode(int i,int len) {
/* Wandlung von i zu Hexstring mit Großbuchstaben und führenden Nullen */
  String s;
  s=Integer.toString(i,16);
  int l=s.length();
  if (len<l) len=l;			// notfalls verlängern
  s="00000"+s.toUpperCase();
  return s.substring(s.length()-len);
 }
 
 public String fromInt(int i) {
  if (i>=0x10000) {
   i-=0x10000;
   char c[]={(char)((i>>10)|0xD800),	// High-Surrogate
        (char)((i&0x3FF)|0xDC00)};	// Low-Surrogare
   return new String(c);		// Zwei Zeichen
  }else{
   char c=(char)i;
   return String.valueOf(c);
  }
 }

 public void paint(Graphics g) {
  int i,j,x,y;
  g.drawString("Zeichentabelle ab Code "
    +Integer.toString(start,16)+"h",10,45);
  g.drawRect(25,70,16*20,16*20);
  for (i=0,x=30,y=60; i<16; i++, x+=20) {
   g.drawString(toHexCode(i,2),x,y);
  }
  for (i=0,y+=25; i<16; i++, y+=20) {
   x=5;
   g.drawString(toHexCode(i*16,2),x,y);
   for (j=0, x+=25; j<16; j++, x+=20) {
    g.drawString(fromInt(i*16+j+start),x,y);
   }
  }
  for (y+=5, i=0; i<area.length; i++) {
   int k=0;
   int a=(int)(area[i].charAt(k++));
   if ((a&0xF800)==0xD800) a=((a&0x3FF)<<10)|((int)(area[i].charAt(k++))&0x3FF);
   int e=(int)(area[i].charAt(k++));
   if ((e&0xF800)==0xD800) e=((e&0x3FF)<<10)|((int)(area[i].charAt(k++))&0x3FF);
   if (a<=start+0xFF & e>=start) {
    if (a==e) g.drawString(toHexCode(a,4)+": ",50,y);
    else g.drawString(toHexCode(a,4)+" - "+toHexCode(e,4)+": ",5,y);
    g.drawString(area[i].substring(k+1),95,y);
    y+=15;
   }  
  }
 }
 
 public void advance(int by) {
  do{
   start += by;
   if (start<0) start += 0x110000;	// wrap around
   else if (start>=0x110000) start -= 0x110000;
  }while ((start&0xFFFFF800) == 0x0000D800);	// skipping low- and high-surrogates
  repaint();
 }

 public boolean action(Event e, Object arg) {
  if (e.target==prev) {
   advance(-0x100);
   return true;
  }else if (e.target==next) {
   advance(0x100);
   return true;
  }else return super.action(e,arg);
 }

 public boolean keyDown(Event e, int key) {
  switch (key) {
   case Event.LEFT: advance(-0x100); break;
   case Event.RIGHT: advance(0x100); break;
  }
  return true;
 }
}
