#include <string.h>
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/pgmspace.h>

#include "FunkUsb.h"

/************************************************************************
 * Ermittlung des Modifizierten Julianischen Datums (MJD), Low-Byte	*
 * Diese Routine ist von 2001 bis 2099 gltig.				*
 * 1. Zur berprfung zweier aufeinanderfolgender Zeittelegramme	*
 * 2. Zur Ablage der Wetterinformation in den Cache24-Flashspeicher	*
 ************************************************************************/

// Tage eines Monats, <m> 1-basiert
byte tage(byte m, byte y) {
 if (m==2) return 28+!(y&3);
 return 30+((m^m>>3)&1);
}

// Fortlaufende Tagesnummer, wie Windows mit 1.1.1601 = 0x00
// Auf Zeitzone bezogen
byte Clocktime::ZoneMJD() const{
 byte ret=year*109;
 ret+=(year-1)>>2;	// fixme: ruft byte->int-Konvertierung auf den Plan
 for (byte i=1; i<=month; i++) ret+=tage(i,year);
 ret+=day-1;		// fixme: ruft byte->int-Konvertierung auf den Plan
 return ret+0x44;
}

// Auf MESZ bezogen (Tagesnummer springt 22:00 Uhr UTC)
void IndexMJD(const Clocktime *t) {
 byte mjd = t->ZoneMJD();
 byte h=t->hour+(t->info&2?0:1);
 if (h>=24) {mjd++; h-=24;};
 wetterReport.cur_mjd = mjd;
 wetterReport.cur_index = t->min/3 + h*20;
}

byte cipher_key[10] __attribute__((section(".noinit")));
// {0x80,0x24,0xCA,0x7B,0x27,0x38,0x02,0x20,0x88,0x15};
// Dieses Beispiel muss 0x0C1011 liefern

//************** Entschlsselung der Wetterdaten via DCF77 *****************

/* byte testdata[10]={0b10000000,0b00100100,0xCA,0x7B,0x27,0x38,0x02,0x20,0x88,0x15};
//		        7...0,    15...8 , 23...16,...

Zielbyte Zielbits #Bits Minute Quellbits (0-basiert)
0        0..5     6     0      2..7    Wetter
0,1      6..11    6     0      9..14   Wetter
1,2,3    12..25   14    1      1..14   Wetter
3,4      26..39   14    2      1..14   Wetter
5        40..46   7     1      21..27  Minute, BCD
5        47       1     -      immer Null
6        48..53   6     1      29..34  Stunde, BCD
6        54..55   2     -      immer Null
7        56..61   6     1      36..41  Tag, BCD
7        62..63   2     -      immer Null
8        64..68   5     1      45..49  Monat, BCD
8        69..71   3     1      42..44  Wochentag
9        72..79   8     1      50..57  Jahr, BCD
*/

void Frame::GrabWetter0() const{
 cipher_key[0] = wl>>2 | wh<<5&0xC0;// 2..7, 9..10
 cipher_key[1] = wh>>3&0x0F;	// 11..14
}

void Frame::GrabWetter1() const{
 cipher_key[1]|= wl<<3&0xF0; 	// 1..4
 cipher_key[2] = w>>5;		// 5..12
 cipher_key[3] = wh>>5&0x03;	// 13..14
// Schlssel setzen: Mit den BCD-Zahlen
 cipher_key[5] = min&0x7F;
 cipher_key[6] = hod&0x3F;
 cipher_key[7] = day>>2;
 cipher_key[8] = wdm<<5|wdm>>3;	// "lsl %0; adc %0,r1; swap %0; std Z+8,%0" wenn Compiler geschickt
 cipher_key[9] = rok;
}

void Frame::GrabWetter2() const{
 cipher_key[3]|= wl<<1&0xFC;	// 1..6
 cipher_key[4] = w>>7;		// 7..14 "lsl %A0; rol %B0; std Z+4,%B0" wenn Compiler geschickt
// CpuFast();
 static long wd __attribute__((section(".noinit")));
 wd=DecodeData(cipher_key);
 if (wd>=0) {
  IndexMJD(&timeReport.t);
  ((byte*)&wd)[3] = wetterReport.cur_mjd;
  flash_write(Cache24+wetterReport.cur_index,&wd,4);
  statusReport.someBits|=0x20;
 }
// CpuSlow();
}
